<?php
session_start();
if (!isset($_SESSION['role']) || $_SESSION['role'] != 'admin') {
    header("Location: ../auth/login.php");
    exit;
}
include "../config/database.php";

if (isset($_POST['simpan'])) {
    $nama = mysqli_real_escape_string($conn, $_POST['nama']);
    $keterangan = mysqli_real_escape_string($conn, $_POST['keterangan']);
    $dana = mysqli_real_escape_string($conn, $_POST['dana']);
    $stmt = mysqli_prepare($conn, "INSERT INTO program_bantuan (nama_program,keterangan,dana,tanggal_buat) VALUES (?, ?, ?, CURDATE())");
    mysqli_stmt_bind_param($stmt, "ssd", $nama, $keterangan, $dana);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
    header("Location: program_bantuan.php");
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Tambah Program</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body class="p-4">
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6">
                <div class="card card-stat shadow">
                    <div class="card-header bg-primary text-white text-center">
                        <h4 class="mb-0"><i class="fas fa-plus-circle"></i> Tambah Program Bantuan</h4>
                    </div>
                    <div class="card-body">
                        <form method="post">
                            <div class="mb-3">
                                <label for="nama" class="form-label"><i class="fas fa-tag"></i> Nama Program</label>
                                <input type="text" id="nama" name="nama" class="form-control" placeholder="Masukkan nama program" required>
                            </div>
                            <div class="mb-3">
                                <label for="keterangan" class="form-label"><i class="fas fa-info-circle"></i> Keterangan</label>
                                <textarea id="keterangan" name="keterangan" class="form-control" rows="4" placeholder="Masukkan keterangan program"></textarea>
                            </div>
                            <div class="mb-3">
                                <label for="dana" class="form-label"><i class="fas fa-money-bill-wave"></i> Dana (Rp)</label>
                                <input type="number" id="dana" name="dana" class="form-control" placeholder="Masukkan jumlah dana" min="0" step="0.01" required>
                            </div>
                            <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                <button name="simpan" class="btn btn-success me-md-2"><i class="fas fa-save"></i> Simpan</button>
                                <a href="program_bantuan.php" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> Kembali</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
