<?php
session_start();
session_destroy();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Logout - Sistem Bantuan Sosial</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="../assets/css/style.css">
    <style>
        body {
            background: linear-gradient(135deg, #74b9ff 0%, #0984e3 100%);
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Arial', sans-serif;
            overflow: hidden;
            animation: bgFade 3s ease-in-out;
        }
        @keyframes bgFade {
            0% { opacity: 0; }
            100% { opacity: 1; }
        }
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><circle cx="50" cy="50" r="2" fill="rgba(255,255,255,0.1)"/><circle cx="20" cy="20" r="1" fill="rgba(255,255,255,0.1)"/><circle cx="80" cy="80" r="1" fill="rgba(255,255,255,0.1)"/></svg>') repeat;
            opacity: 0.5;
            z-index: -1;
            animation: float 10s ease-in-out infinite;
        }
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
        }
        .logout-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
            backdrop-filter: blur(15px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            max-width: 420px;
            width: 100%;
            animation: zoomIn 0.8s ease-out;
        }
        @keyframes zoomIn {
            from { opacity: 0; transform: scale(0.8); }
            to { opacity: 1; transform: scale(1); }
        }
        .logout-card .card-header {
            background: linear-gradient(135deg, #0984e3 0%, #74b9ff 100%);
            color: white;
            border-radius: 20px 20px 0 0 !important;
            text-align: center;
            padding: 20px;
            border-bottom: none;
        }
        .logout-card .card-header i {
            font-size: 3rem;
            margin-bottom: 10px;
            animation: checkmark 1s ease-out 0.5s forwards;
        }
        @keyframes checkmark {
            0% { transform: scale(0) rotate(0deg); opacity: 0; }
            50% { transform: scale(1.2) rotate(180deg); opacity: 1; }
            100% { transform: scale(1) rotate(360deg); opacity: 1; }
        }
        .logout-card .card-body {
            padding: 30px;
            text-align: center;
        }
        .logout-card h4 {
            color: #333;
            font-weight: bold;
            margin-bottom: 20px;
            animation: textFade 1s ease-out 1s forwards;
            opacity: 0;
        }
        @keyframes textFade {
            to { opacity: 1; }
        }
        .logout-card p {
            color: #666;
            margin-bottom: 20px;
            animation: textFade 1s ease-out 1.2s forwards;
            opacity: 0;
        }
        .progress-bar {
            animation: progress 3s linear;
        }
        @keyframes progress {
            0% { width: 0%; }
            100% { width: 100%; }
        }
        a {
            color: #0984e3;
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s ease;
        }
        a:hover {
            color: #74b9ff;
            text-decoration: underline;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-6 col-lg-4">
            <div class="card logout-card">
                <div class="card-header">
                    <i class="fas fa-check-circle"></i>
                    <h4 class="mb-0">Logout Berhasil</h4>
                </div>
                <div class="card-body">
                    <h4>Anda telah berhasil logout</h4>
                    <p>Terima kasih telah menggunakan Sistem Bantuan Sosial. Anda akan diarahkan ke halaman login dalam beberapa detik.</p>
                    <div class="progress mb-3">
                        <div class="progress-bar bg-primary" role="progressbar" style="width: 0%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>
                    <a href="login.php" class="btn btn-primary"><i class="fas fa-sign-in-alt"></i> Login Sekarang</a>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
    setTimeout(function() {
        window.location.href = 'login.php';
    }, 3000); // Redirect after 3 seconds
</script>
</body>
</html>
