<?php
session_start();
include "../config/database.php";
$error = '';
if (isset($_POST['daftar'])) {
    $nama = mysqli_real_escape_string($conn, $_POST['nama']);
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $password = $_POST['password'];
    if (empty($nama) || empty($email) || empty($password)) {
        $error = "Isi semua field.";
    } else {
        $hash = password_hash($password, PASSWORD_DEFAULT);
        $stmt = mysqli_prepare($conn, "INSERT INTO users (nama, email, password, role) VALUES (?, ?, ?, 'user')");
        mysqli_stmt_bind_param($stmt, "sss", $nama, $email, $hash);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
        header("Location: login.php");
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Register - Sistem Bantuan Sosial</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="../assets/css/style.css">
    <style>
        body {
            background: linear-gradient(135deg, #74b9ff 0%, #0984e3 100%);
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Arial', sans-serif;
            overflow: hidden;
            animation: bgMove 20s ease-in-out infinite;
        }
        @keyframes bgMove {
            0%, 100% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
        }
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><circle cx="50" cy="50" r="2" fill="rgba(255,255,255,0.1)"/><circle cx="20" cy="20" r="1" fill="rgba(255,255,255,0.1)"/><circle cx="80" cy="80" r="1" fill="rgba(255,255,255,0.1)"/></svg>') repeat;
            opacity: 0.5;
            z-index: -1;
            animation: float 10s ease-in-out infinite;
        }
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
        }
        .register-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
            backdrop-filter: blur(15px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            max-width: 450px;
            width: 100%;
            animation: slideIn 1s ease-out;
        }
        @keyframes slideIn {
            from { opacity: 0; transform: translateY(50px) scale(0.9); }
            to { opacity: 1; transform: translateY(0) scale(1); }
        }
        .register-card .card-header {
            background: linear-gradient(135deg, #0984e3 0%, #74b9ff 100%);
            color: white;
            border-radius: 20px 20px 0 0 !important;
            text-align: center;
            padding: 20px;
            border-bottom: none;
            animation: headerPulse 2s ease-in-out infinite;
        }
        @keyframes headerPulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.02); }
        }
        .register-card .card-header i {
            font-size: 2rem;
            margin-bottom: 10px;
            animation: iconBounce 3s ease-in-out infinite;
        }
        @keyframes iconBounce {
            0%, 20%, 50%, 80%, 100% { transform: translateY(0); }
            40% { transform: translateY(-10px); }
            60% { transform: translateY(-5px); }
        }
        .register-card .card-body {
            padding: 30px;
        }
        .form-group {
            animation: staggerIn 0.5s ease-out forwards;
            opacity: 0;
        }
        .form-group:nth-child(1) { animation-delay: 0.2s; }
        .form-group:nth-child(2) { animation-delay: 0.4s; }
        .form-group:nth-child(3) { animation-delay: 0.6s; }
        .form-group:nth-child(4) { animation-delay: 0.8s; }
        @keyframes staggerIn {
            to { opacity: 1; transform: translateX(0); }
            from { opacity: 0; transform: translateX(-20px); }
        }
        .form-control {
            border-radius: 12px;
            border: 1px solid #ddd;
            padding: 12px 15px;
            transition: all 0.3s ease;
        }
        .form-control:focus {
            border-color: #0984e3;
            box-shadow: 0 0 8px rgba(9, 132, 227, 0.3);
            transform: scale(1.02);
            animation: inputGlow 0.5s ease-out;
        }
        @keyframes inputGlow {
            0% { box-shadow: 0 0 0 rgba(9, 132, 227, 0); }
            100% { box-shadow: 0 0 8px rgba(9, 132, 227, 0.3); }
        }
        .btn-primary {
            background: linear-gradient(135deg, #0984e3 0%, #74b9ff 100%);
            border: none;
            border-radius: 12px;
            padding: 12px;
            font-weight: bold;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        .btn-primary::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.5s;
        }
        .btn-primary:hover::before {
            left: 100%;
        }
        .btn-primary:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(9, 132, 227, 0.4);
        }
        .alert {
            border-radius: 12px;
            animation: alertSlide 0.5s ease-out;
        }
        @keyframes alertSlide {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        a {
            color: #0984e3;
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s ease;
        }
        a:hover {
            color: #74b9ff;
            text-decoration: underline;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-6 col-lg-5">
            <div class="card register-card">
                <div class="card-header">
                    <i class="fas fa-user-plus"></i>
                    <h4 class="mb-0">Register User</h4>
                </div>
                <div class="card-body">
                    <?php if($error): ?>
                        <div class="alert alert-danger text-center"><?= htmlspecialchars($error) ?></div>
                    <?php endif; ?>
                    <form method="post">
                        <div class="form-group mb-3">
                            <label for="nama" class="form-label"><i class="fas fa-user"></i> Nama Lengkap</label>
                            <input type="text" name="nama" id="nama" class="form-control" placeholder="Masukkan nama lengkap Anda" required>
                        </div>
                        <div class="form-group mb-3">
                            <label for="email" class="form-label"><i class="fas fa-envelope"></i> Email</label>
                            <input type="email" name="email" id="email" class="form-control" placeholder="Masukkan email Anda" required>
                        </div>
                        <div class="form-group mb-3">
                            <label for="password" class="form-label"><i class="fas fa-lock"></i> Password</label>
                            <input type="password" name="password" id="password" class="form-control" placeholder="Masukkan password Anda" required>
                        </div>
                        <div class="form-group">
                            <button type="submit" name="daftar" class="btn btn-primary w-100"><i class="fas fa-user-plus"></i> Daftar</button>
                        </div>
                    </form>
                    <div class="text-center mt-3">
                        <a href="login.php"><i class="fas fa-sign-in-alt"></i> Sudah punya akun? Login</a><br>
                        <a href="../index.php" class="mt-2 d-block"><i class="fas fa-home"></i> Kembali ke Home</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
