<?php
session_start();
if (!isset($_SESSION['role']) || $_SESSION['role'] != 'user') {
    header("Location: ../auth/login.php");
    exit;
}
include "../config/database.php";

$id_user = $_SESSION['id_user'];
$data = mysqli_query($conn,"SELECT pengajuan.*, program_bantuan.nama_program FROM pengajuan JOIN program_bantuan ON pengajuan.id_program = program_bantuan.id_program WHERE pengajuan.id_user = $id_user ORDER BY pengajuan.id_pengajuan DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Pengajuan Saya - Sistem Bantuan Sosial</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="../assets/css/style.css">
    <style>
        body {
            background: linear-gradient(135deg, #74b9ff 0%, #0984e3 100%);
            min-height: 100vh;
            font-family: 'Arial', sans-serif;
            animation: bgFade 2s ease-in-out;
            margin: 0;
            padding: 0;
        }
        @keyframes bgFade {
            0% { opacity: 0; }
            100% { opacity: 1; }
        }
        .pengajuan-container {
            padding: 40px 20px;
            animation: containerSlide 1s ease-out;
        }
        @keyframes containerSlide {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .pengajuan-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            backdrop-filter: blur(10px);
            border: none;
            animation: cardFade 0.8s ease-out 0.2s forwards;
            opacity: 0;
            padding: 30px;
        }
        @keyframes cardFade {
            to { opacity: 1; transform: translateY(0); }
            from { opacity: 0; transform: translateY(20px); }
        }
        .table {
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        .table thead th {
            background: linear-gradient(135deg, #0984e3 0%, #74b9ff 100%);
            color: white;
            border: none;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        .table tbody tr {
            animation: rowStagger 0.5s ease-out forwards;
            opacity: 0;
        }
        .table tbody tr:nth-child(1) { animation-delay: 0.4s; }
        .table tbody tr:nth-child(2) { animation-delay: 0.5s; }
        .table tbody tr:nth-child(3) { animation-delay: 0.6s; }
        .table tbody tr:nth-child(4) { animation-delay: 0.7s; }
        .table tbody tr:nth-child(5) { animation-delay: 0.8s; }
        .table tbody tr:nth-child(n+6) { animation-delay: 0.9s; }
        @keyframes rowStagger {
            to { opacity: 1; transform: translateX(0); }
            from { opacity: 0; transform: translateX(-20px); }
        }
        .table tbody tr:hover {
            background-color: rgba(9, 132, 227, 0.1);
            transform: scale(1.01);
            transition: all 0.3s ease;
        }
        .table td {
            vertical-align: middle;
            padding: 15px;
        }
        .badge {
            font-size: 0.8rem;
            padding: 5px 10px;
            border-radius: 20px;
        }
        .btn-custom {
            border-radius: 10px;
            padding: 10px 20px;
            font-weight: 600;
            transition: all 0.3s ease;
            margin: 5px;
            animation: btnFade 0.5s ease-out 1s forwards;
            opacity: 0;
        }
        @keyframes btnFade {
            to { opacity: 1; }
        }
        .btn-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }
        .btn-secondary { background: linear-gradient(135deg, #636e72 0%, #b2bec3 100%); border: none; }
        .no-data {
            text-align: center;
            padding: 50px;
            color: #666;
            animation: noDataFade 1s ease-out 0.5s forwards;
            opacity: 0;
        }
        @keyframes noDataFade {
            to { opacity: 1; }
        }
        .container {
            max-width: 1200px;
        }
    </style>
</head>
<body>
<div class="pengajuan-container">
    <div class="container">
        <div class="pengajuan-card">
            <h3 class="text-center mb-4"><i class="fas fa-list-alt"></i> Pengajuan Saya</h3>
            <div class="text-center mb-4">
                <a href="dashboard.php" class="btn btn-secondary btn-custom"><i class="fas fa-arrow-left"></i> Kembali ke Dashboard</a>
            </div>
            <?php if (mysqli_num_rows($data) > 0): ?>
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th style="width: 5%;">No</th>
                                <th style="width: 30%;"><i class="fas fa-hand-holding-heart"></i> Program</th>
                                <th style="width: 15%;"><i class="fas fa-info-circle"></i> Status</th>
                                <th style="width: 20%;"><i class="fas fa-money-bill-wave"></i> Dana</th>
                                <th style="width: 30%;"><i class="fas fa-calendar"></i> Tanggal</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $no = 1; while ($row = mysqli_fetch_assoc($data)): ?>
                                <tr>
                                    <td><?= $no++ ?></td>
                                    <td><?= htmlspecialchars($row['nama_program']) ?></td>
                                    <td>
                                        <?php
                                        $status = htmlspecialchars($row['status']);
                                        $badgeClass = 'bg-secondary';
                                        if ($status == 'disetujui') $badgeClass = 'bg-success';
                                        elseif ($status == 'ditolak') $badgeClass = 'bg-danger';
                                        elseif ($status == 'pending') $badgeClass = 'bg-warning';
                                        ?>
                                        <span class="badge <?= $badgeClass ?>"><?= ucfirst($status) ?></span>
                                    </td>
                                    <td>Rp <?= number_format($row['dana'], 2, ',', '.') ?></td>
                                    <td><?= htmlspecialchars($row['tanggal_pengajuan']) ?></td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="no-data">
                    <i class="fas fa-inbox fa-3x mb-3"></i>
                    <h5>Belum ada pengajuan</h5>
                    <p>Ajukan bantuan sekarang untuk melihat status pengajuan Anda.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
